using System;
using System.Web;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;
using System.Data.Linq;

namespace VIRP.CRS.DAL
{
	public partial class WKF_CASE_ACTIVITYDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public WKF_CASE_ACTIVITYDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public WKF_CASE_ACTIVITY GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID)
        {
            WKF_CASE_ACTIVITY objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_WKF_CASE_ACTIVITY_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);

                    if (objReturn != null)
                    {
                        if (objReturn.WKF_CASE_ID > 0)
                        {
                            objReturn.WKF_CASE = dbContext.usp_WKF_CASE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.WKF_CASE_ID).FirstOrDefault();
                            if (objReturn.WKF_CASE != null)
                            {
                                if (objReturn.WKF_CASE.STD_WKFCASETYPE_ID > 0)
                                    objReturn.WKF_CASE.STD_WKFCASETYPE = dbContext.usp_STD_WKFCASETYPE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.WKF_CASE.STD_WKFCASETYPE_ID).FirstOrDefault();

                                if (objReturn.WKF_CASE.STD_WKFCASESTS_ID > 0)
                                    objReturn.WKF_CASE.STD_WKFCASESTS = dbContext.usp_STD_WKFCASESTS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.WKF_CASE.STD_WKFCASESTS_ID).FirstOrDefault();

                                if (objReturn.WKF_CASE.PATIENT_ID > 0)
                                    objReturn.WKF_CASE.PATIENT = dbContext.usp_PATIENT_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.WKF_CASE.PATIENT_ID).FirstOrDefault();

                                if (objReturn.WKF_CASE.REFERRAL_ID != null && objReturn.WKF_CASE.REFERRAL_ID > 0)
                                {
                                    REFERRALDB refDB = new REFERRALDB();
                                    objReturn.WKF_CASE.REFERRAL = refDB.GetItemComplete(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.WKF_CASE.REFERRAL_ID.Value);
                                }
                            }
                        }

                        if (objReturn.STD_WKFACTIVITYTYPE_ID > 0)
                        {
                            objReturn.STD_WKFACTIVITYTYPE = dbContext.usp_STD_WKFACTIVITYTYPE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.STD_WKFACTIVITYTYPE_ID).FirstOrDefault();
                        }

                        if (objReturn.STD_WKFACTIVITYSTS_ID > 0)
                        {
                            objReturn.STD_WKFACTIVITYSTS = dbContext.usp_STD_WKFACTIVITYSTS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, objReturn.STD_WKFACTIVITYSTS_ID).FirstOrDefault();
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<WKF_CASE_ACTIVITY> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<WKF_CASE_ACTIVITY> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_WKF_CASE_ACTIVITY_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<KitOrders> GetOrderedKitOrders(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<KitOrders> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_WKF_CASE_ACTIVITY_GetOrderedKitOrders(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<LabResult> GetNewLabResults(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, int STD_WKFACTIVITYSTS_ID)
        {
            List<LabResult> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_WKF_CASE_ACTIVITY_GetNewLabResults(CURRENT_USER, CURRENT_REGISTRY_ID, STD_WKFACTIVITYSTS_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY objSave)
        {
            Int32? objReturn = objSave.WKF_CASE_ACTIVITY_ID;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    if (string.IsNullOrEmpty(objSave.CREATEDBY))
                        objSave.CREATEDBY = CURRENT_USER;

                    if (string.IsNullOrEmpty(objSave.UPDATEDBY))
                        objSave.UPDATEDBY = CURRENT_USER;

                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_WKF_CASE_ACTIVITY_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.ADDRESS_LINE1, objSave.ADDRESS_LINE2, objSave.ADDRESS_LINE3, objSave.BEST_CALL_BACK_TIME, objSave.CITY, objSave.CONTACT_EMAIL, objSave.CONTACT_NAME, objSave.CONTACT_PHONE, objSave.COUNTRY, objSave.CREATED, objSave.CREATEDBY, objSave.INFO_CONVEYED_TEXT, objSave.INFO_RECEIVED_TEXT, objSave.POSTAL_CODE, objSave.STATE, objSave.STD_WKFACTIVITYTYPE_ID, objSave.UPDATED, objSave.UPDATEDBY, ref objReturn, objSave.WKF_CASE_ID, objSave.STD_WKFACTIVITYSTS_ID, objSave.KIT_ORDER_DATE, objSave.ARCHIVED_FLAG, objSave.REPRESENTATIVE_NAME, objSave.CONTACT_METHOD_CODE, objSave.CONTACT_REASON_CODE, objSave.COUNTY, objSave.FOLLOWUP_DECLINED_DATE, objSave.FOLLOWUP_PLAN_DATE, objSave.FOLLOWUP_REMINDER_DATE, objSave.FOLLOWUP_REQUIRED_FLAG, objSave.FOLLOWUP_WKF_CASE_ID, objSave.INPATIENT_EVAL_DATE, objSave.KIT_USE_STOCK_FLAG, objSave.PATIENT_TELEMEDICINE_FLAG, objSave.PROVIDER_TELEMEDICINE_FLAG, objSave.STD_TBIEVALDELAYTYPE_ID, objSave.STD_TBISCHEDULESTS_ID, objSave.TBI_CONTACT_ATTEMPT_COUNT, objSave.TBI_EVALUATION_SCHEDULE_DATE, objSave.ZIP_PLUS_4);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Int32 SaveFromReferral(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY objSave)
        {
            Int32? objReturn = objSave.WKF_CASE_ACTIVITY_ID;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_WKF_CASE_ACTIVITY_saveFromReferral(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.ADDRESS_LINE1, objSave.ADDRESS_LINE2, objSave.ADDRESS_LINE3, objSave.BEST_CALL_BACK_TIME, objSave.CITY, objSave.CONTACT_EMAIL, objSave.CONTACT_NAME, objSave.CONTACT_PHONE, objSave.COUNTRY, DateTime.Now, objSave.CREATEDBY, objSave.INFO_CONVEYED_TEXT, objSave.INFO_RECEIVED_TEXT, objSave.POSTAL_CODE, objSave.STATE, objSave.STD_WKFACTIVITYTYPE_ID, DateTime.Now, objSave.UPDATEDBY, ref objReturn, objSave.WKF_CASE_ID, objSave.STD_WKFACTIVITYSTS_ID, objSave.FOLLOWUP_REQUIRED_FLAG, objSave.FOLLOWUP_DECLINED_DATE);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Int32 SaveAll(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, List<WKF_CASE_ACTIVITY> objSave)
        {
            Int32 objReturn = 0;
            Int32? objRef = 0;

            try
            {
                if (objSave != null)
                {
                    using (VIRPDBDataContext dbContext = GetDataContext())
                    {
                        foreach (WKF_CASE_ACTIVITY objTemp in objSave)
                        {
                            // Reset otherwise we'll update the same record each time
                            objRef = 0;

                            if (string.IsNullOrEmpty(objTemp.CREATEDBY))
                                objTemp.CREATEDBY = CURRENT_USER;

                            if (string.IsNullOrEmpty(objTemp.UPDATEDBY))
                                objTemp.UPDATEDBY = CURRENT_USER;

                            LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                            dbContext.usp_WKF_CASE_ACTIVITY_save(CURRENT_USER, CURRENT_REGISTRY_ID, objTemp.ADDRESS_LINE1, objTemp.ADDRESS_LINE2, objTemp.ADDRESS_LINE3, objTemp.BEST_CALL_BACK_TIME, objTemp.CITY, objTemp.CONTACT_EMAIL, objTemp.CONTACT_NAME, objTemp.CONTACT_PHONE, objTemp.COUNTRY, objTemp.CREATED, objTemp.CREATEDBY, objTemp.INFO_CONVEYED_TEXT, objTemp.INFO_RECEIVED_TEXT, objTemp.POSTAL_CODE, objTemp.STATE, objTemp.STD_WKFACTIVITYTYPE_ID, objTemp.UPDATED, objTemp.UPDATEDBY, ref objRef, objTemp.WKF_CASE_ID, objTemp.STD_WKFACTIVITYSTS_ID, objTemp.KIT_ORDER_DATE, objTemp.ARCHIVED_FLAG, objTemp.REPRESENTATIVE_NAME, objTemp.CONTACT_METHOD_CODE, objTemp.CONTACT_REASON_CODE, objTemp.COUNTY, objTemp.FOLLOWUP_DECLINED_DATE, objTemp.FOLLOWUP_PLAN_DATE, objTemp.FOLLOWUP_REMINDER_DATE, objTemp.FOLLOWUP_REQUIRED_FLAG, objTemp.FOLLOWUP_WKF_CASE_ID, objTemp.INPATIENT_EVAL_DATE, objTemp.KIT_USE_STOCK_FLAG, objTemp.PATIENT_TELEMEDICINE_FLAG, objTemp.PROVIDER_TELEMEDICINE_FLAG, objTemp.STD_TBIEVALDELAYTYPE_ID, objTemp.STD_TBISCHEDULESTS_ID, objTemp.TBI_CONTACT_ATTEMPT_COUNT, objTemp.TBI_EVALUATION_SCHEDULE_DATE, objTemp.ZIP_PLUS_4);
                            LogManager.LogTiming(logDetails);
                            objReturn++;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_WKF_CASE_ACTIVITY_delete(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<WKF_CASE_ACTIVITY> GetItemsByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<WKF_CASE_ACTIVITY> objReturn = null;
            List<STD_WKFACTIVITYTYPE> objTemp = null;

            //TODO: Revisit

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    //objReturn = dbContext.usp_WKF_CASE_ACTIVITY_getitemsByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    objTemp = dbContext.usp_STD_WKFACTIVITYTYPE_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    objTemp = objTemp.Where(r => r.STD_REGISTRY_ID == CURRENT_REGISTRY_ID).ToList();
                    objReturn = dbContext.usp_WKF_CASE_ACTIVITY_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    if (objReturn != null && objTemp != null)
                        objReturn = (from s in objReturn where (from t in objTemp select t.ID).Contains(s.STD_WKFACTIVITYTYPE_ID) select s).ToList();

                    LogManager.LogTiming(logDetails);

                    if (objReturn != null)
                    {
                        foreach (WKF_CASE_ACTIVITY act in objReturn)
                        {
                            if (act.WKF_CASE_ID > 0)
                            {
                                act.WKF_CASE = dbContext.usp_WKF_CASE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.WKF_CASE_ID).FirstOrDefault();
                                if (act.WKF_CASE != null)
                                {
                                    if (act.WKF_CASE.STD_WKFCASETYPE_ID > 0)
                                        act.WKF_CASE.STD_WKFCASETYPE = dbContext.usp_STD_WKFCASETYPE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.WKF_CASE.STD_WKFCASETYPE_ID).FirstOrDefault();

                                    if (act.WKF_CASE.STD_WKFCASESTS_ID > 0)
                                        act.WKF_CASE.STD_WKFCASESTS = dbContext.usp_STD_WKFCASESTS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.WKF_CASE.STD_WKFCASESTS_ID).FirstOrDefault();

                                    if (act.WKF_CASE.PATIENT_ID > 0)
                                        act.WKF_CASE.PATIENT = dbContext.usp_PATIENT_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.WKF_CASE.PATIENT_ID).FirstOrDefault();

                                    if (act.WKF_CASE.REFERRAL_ID != null && act.WKF_CASE.REFERRAL_ID > 0)
                                        act.WKF_CASE.REFERRAL = dbContext.usp_REFERRAL_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.WKF_CASE.REFERRAL_ID.Value).FirstOrDefault();
                                }
                            }

                            if (act.STD_WKFACTIVITYTYPE_ID > 0)
                            {
                                act.STD_WKFACTIVITYTYPE = dbContext.usp_STD_WKFACTIVITYTYPE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.STD_WKFACTIVITYTYPE_ID).FirstOrDefault();
                            }

                            if (act.STD_WKFACTIVITYSTS_ID > 0)
                            {
                                act.STD_WKFACTIVITYSTS = dbContext.usp_STD_WKFACTIVITYSTS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.STD_WKFACTIVITYSTS_ID).FirstOrDefault();
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<WKF_CASE_ACTIVITY> GetItemsByWorkstream(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ID)
        {
            List<WKF_CASE_ACTIVITY> objReturn = null;
            List<WKF_CASE> cases = null;
            List<STD_WKFACTIVITYTYPE> types = null;
            List<STD_WKFACTIVITYSTS> sts = null;

            //TODO: Revisit

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    //objReturn = dbContext.usp_WKF_CASE_ACTIVITY_getitemsByWorkstream(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID).ToList();
                    //objReturn = dbContext.usp_WKF_CASE_ACTIVITY_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    //objReturn = objReturn.Where(r => r.WKF_CASE_ID == WKF_CASE_ID).ToList();

                    IMultipleResults sprocResults = dbContext.usp_WKF_CASE_ACTIVITY_getitemsByWorkflowCaseId(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID);
                    objReturn = sprocResults.GetResult<WKF_CASE_ACTIVITY>().ToList();
                    cases = sprocResults.GetResult<WKF_CASE>().ToList();
                    types = sprocResults.GetResult<STD_WKFACTIVITYTYPE>().ToList();
                    sts = sprocResults.GetResult<STD_WKFACTIVITYSTS>().ToList();

                    LogManager.LogTiming(logDetails);

                    if (objReturn != null && objReturn.Any())
                    {
                        WKF_CASEDB caseDB = new WKF_CASEDB();

                        foreach (WKF_CASE_ACTIVITY activity in objReturn)
                        {
                            activity.WKF_CASE = caseDB.GetItemByActivity(CURRENT_USER, CURRENT_REGISTRY_ID, activity.WKF_CASE_ACTIVITY_ID);
                            //activity.WKF_CASE = cases.SingleOrDefault(c => c.WKF_CASE_ID == activity.WKF_CASE_ID);
                            activity.STD_WKFACTIVITYTYPE = types.SingleOrDefault(t => t.ID == activity.STD_WKFACTIVITYTYPE_ID);
                            activity.STD_WKFACTIVITYSTS = sts.SingleOrDefault(s => s.ID == activity.STD_WKFACTIVITYSTS_ID);
                        }
                    }

                    //if (objReturn != null)
                    //{
                    //    foreach (WKF_CASE_ACTIVITY act in objReturn)
                    //    {
                    //        if (act.WKF_CASE_ACTIVITY_ID > 0)
                    //        {
                    //            WKF_CASEDB caseDB = new WKF_CASEDB();
                    //            act.WKF_CASE = caseDB.GetItemByActivity(CURRENT_USER, CURRENT_REGISTRY_ID, act.WKF_CASE_ACTIVITY_ID);
                    //        }

                    //        if (act.STD_WKFACTIVITYTYPE_ID > 0)
                    //        {
                    //            act.STD_WKFACTIVITYTYPE = dbContext.usp_STD_WKFACTIVITYTYPE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.STD_WKFACTIVITYTYPE_ID).FirstOrDefault();
                    //        }

                    //        if (act.STD_WKFACTIVITYSTS_ID > 0)
                    //        {
                    //            act.STD_WKFACTIVITYSTS = dbContext.usp_STD_WKFACTIVITYSTS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, act.STD_WKFACTIVITYSTS_ID).FirstOrDefault();
                    //        }
                    //    }
                    //}
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<LabOrderByStatus> GetItemsByStatus(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 STD_WKFACTIVITYSTS_ID)
        {
            List<LabOrderByStatus> objReturn = null;

            //TODO: Revisit

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    objReturn = dbContext.usp_WKF_CASE_ACTIVITY_SelectByStatus(CURRENT_USER, CURRENT_REGISTRY_ID, STD_WKFACTIVITYSTS_ID).ToList();

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<WKF_CASE_ACTIVITY> GetitemsByWorkflowCaseId(string CURRENT_USER, int CURRENT_REGISTRY_ID, int WKF_CASE_ID)
        {
            List<WKF_CASE_ACTIVITY> activities = null;
            List<WKF_CASE> cases = null;
            List<STD_WKFACTIVITYTYPE> types = null;
            List<STD_WKFACTIVITYSTS> sts = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    IMultipleResults sprocResults = dbContext.usp_WKF_CASE_ACTIVITY_getitemsByWorkflowCaseId(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID);

                    activities = sprocResults.GetResult<WKF_CASE_ACTIVITY>().ToList();
                    cases = sprocResults.GetResult<WKF_CASE>().ToList();
                    types = sprocResults.GetResult<STD_WKFACTIVITYTYPE>().ToList();
                    sts = sprocResults.GetResult<STD_WKFACTIVITYSTS>().ToList();

                    LogManager.LogTiming(logDetails);
                }

                if (activities != null && activities.Any())
                {
                    foreach (WKF_CASE_ACTIVITY activity in activities)
                    {
                        activity.WKF_CASE = cases.SingleOrDefault(c => c.WKF_CASE_ID == activity.WKF_CASE_ID);
                        activity.STD_WKFACTIVITYTYPE = types.SingleOrDefault(t => t.ID == activity.STD_WKFACTIVITYTYPE_ID);
                        activity.STD_WKFACTIVITYSTS = sts.SingleOrDefault(s => s.ID == activity.STD_WKFACTIVITYSTS_ID);
                    }

                    return activities;
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return null;
        }

        public Boolean UpdateStatus(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID, Int32 STD_WKFACTIVITYSTS_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_WKF_CASE_ACTIVITY_updateStatus(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID, STD_WKFACTIVITYSTS_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

		#endregion
	}
}
